/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.json_model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.moulberry.axiom.hooks.ModelManagerExt;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.model.loading.v1.DelegatingUnbakedModel;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_1086;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4609;
import net.minecraft.class_773;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_807;
import net.minecraft.class_813;
import net.minecraft.class_816;
import net.minecraft.class_819;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BlocksToJsonModel {
    public static JsonObject convertBlocksToJsonModel(ChunkedBlockRegion chunkedBlockRegion) {
        JsonObject jsonObject = new JsonObject();
        class_2350[] DIRECTIONS = class_2350.values();
        class_2338.class_2339 blockPosition = new class_2338.class_2339();
        class_2338.class_2339 neighborPosition = new class_2338.class_2339();
        Map<class_2960, class_793> blockModels = ((ModelManagerExt)class_310.method_1551().method_1554()).loadBlockModels(class_310.method_1551().method_1478());
        Map<class_2960, List<class_1088.class_7777>> blockStates = ((ModelManagerExt)class_310.method_1551().method_1554()).loadBlockStates(class_310.method_1551().method_1478());
        try {
            List currentPlugins = (List)ModelLoadingPluginManager.preparePlugins((class_3300)class_310.method_1551().method_1478(), (Executor)Executors.newSingleThreadExecutor()).join();
            ModelLoadingPluginManager.CURRENT_PLUGINS.set(currentPlugins);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        class_1088 modelBakery = new class_1088(class_310.method_1551().method_1505(), class_310.method_1551().method_16011(), blockModels, blockStates);
        JsonArray elements = new JsonArray();
        HashMap textureReferences = new HashMap();
        class_2338 max2 = chunkedBlockRegion.max();
        class_2338 min2 = chunkedBlockRegion.min();
        float scaleX = 1.0f / (float)(max2.method_10263() + 1 - min2.method_10263());
        float scaleY = 1.0f / (float)(max2.method_10264() + 1 - min2.method_10264());
        float scaleZ = 1.0f / (float)(max2.method_10260() + 1 - min2.method_10260());
        float globalScale = Math.min(scaleX, Math.min(scaleY, scaleZ));
        float centeringX = 8.0f - (float)(max2.method_10263() + 1 + min2.method_10263()) * globalScale * 8.0f;
        float centeringY = 8.0f - (float)(max2.method_10264() + 1 + min2.method_10264()) * globalScale * 8.0f;
        float centeringZ = 8.0f - (float)(max2.method_10260() + 1 + min2.method_10260()) * globalScale * 8.0f;
        chunkedBlockRegion.forEachEntry((x, y, z, blockState) -> {
            if (blockState.method_26215() || blockState.method_26217() == class_2464.field_11455) {
                return;
            }
            List<ModelAndState> models = BlocksToJsonModel.getBlockModels(modelBakery, blockState);
            if (models.isEmpty()) {
                return;
            }
            blockPosition.method_10103(x, y, z);
            EnumSet<class_2350> allowedDirection = EnumSet.noneOf(class_2350.class);
            for (class_2350 direction : DIRECTIONS) {
                neighborPosition.method_25505((class_2382)blockPosition, direction);
                if (!class_2248.method_9607((class_2680)blockState, (class_1922)chunkedBlockRegion, (class_2338)blockPosition, (class_2350)direction, (class_2338)neighborPosition)) continue;
                allowedDirection.add(direction);
            }
            class_1091 blockStateResourceLocation = class_773.method_3340((class_2680)blockState);
            for (ModelAndState modelAndState : models) {
                class_793 model = modelAndState.blockModel();
                class_3665 state = modelAndState.modelState();
                for (class_785 blockElement : model.method_3433()) {
                    JsonObject faces = new JsonObject();
                    for (Map.Entry entry : blockElement.field_4230.entrySet()) {
                        class_2960 resourceLocation;
                        class_2350 rotated;
                        class_783 face = (class_783)entry.getValue();
                        class_2350 cullForDirection = face.field_4225;
                        int tintIndex = face.field_4226;
                        String texture = face.field_4224;
                        class_787 blockFaceUV = face.field_4227;
                        if (cullForDirection != null && !allowedDirection.contains(rotated = class_2350.method_23225((Matrix4f)state.method_3509().method_22936(), (class_2350)cullForDirection))) continue;
                        JsonObject faceObject = new JsonObject();
                        if (tintIndex != -1) {
                            faceObject.addProperty("tintindex", (Number)tintIndex);
                        }
                        if (textureReferences.containsKey(resourceLocation = model.method_24077(texture).method_24147())) {
                            faceObject.addProperty("texture", "#" + (String)textureReferences.get(resourceLocation));
                        } else {
                            String identifier = BlocksToJsonModel.getIdentifierForIndex(textureReferences.size());
                            textureReferences.put(resourceLocation, identifier);
                            faceObject.addProperty("texture", "#" + identifier);
                        }
                        blockFaceUV = state.method_3512() ? BlocksToJsonModel.recomputeUVLocked(blockFaceUV, (class_2350)entry.getKey(), state.method_3509(), blockStateResourceLocation.toString()) : BlocksToJsonModel.recomputeUVNonLocked(blockFaceUV, (class_2350)entry.getKey(), state.method_3509());
                        JsonArray jsonArray = new JsonArray();
                        for (float uv : blockFaceUV.field_4235) {
                            jsonArray.add((Number)Float.valueOf(uv));
                        }
                        faceObject.add("uv", (JsonElement)jsonArray);
                        class_2350 newFacing = class_2350.method_23225((Matrix4f)state.method_3509().method_22936(), (class_2350)((class_2350)entry.getKey()));
                        int rotation = blockFaceUV.field_4234;
                        if ((rotation %= 360) < 0) {
                            rotation += 360;
                        }
                        if (rotation != 0) {
                            faceObject.addProperty("rotation", (Number)rotation);
                        }
                        faces.add(newFacing.name().toLowerCase(Locale.ROOT), (JsonElement)faceObject);
                    }
                    if (faces.size() == 0) continue;
                    Vector4f fromCopy = new Vector4f(blockElement.field_4228.x - 8.0f, blockElement.field_4228.y - 8.0f, blockElement.field_4228.z - 8.0f, 1.0f);
                    Vector4f toCopy = new Vector4f(blockElement.field_4231.x - 8.0f, blockElement.field_4231.y - 8.0f, blockElement.field_4231.z - 8.0f, 1.0f);
                    state.method_3509().method_22936().transform(fromCopy);
                    state.method_3509().method_22936().transform(toCopy);
                    if (fromCopy.x > toCopy.x != blockElement.field_4228.x > blockElement.field_4231.x) {
                        float temp = fromCopy.x;
                        fromCopy.x = toCopy.x;
                        toCopy.x = temp;
                    }
                    if (fromCopy.y > toCopy.y != blockElement.field_4228.y > blockElement.field_4231.y) {
                        float temp = fromCopy.y;
                        fromCopy.y = toCopy.y;
                        toCopy.y = temp;
                    }
                    if (fromCopy.z > toCopy.z != blockElement.field_4228.z > blockElement.field_4231.z) {
                        float temp = fromCopy.z;
                        fromCopy.z = toCopy.z;
                        toCopy.z = temp;
                    }
                    JsonObject blockElementObj = new JsonObject();
                    blockElementObj.add("faces", (JsonElement)faces);
                    JsonArray from = new JsonArray();
                    from.add((Number)Float.valueOf((fromCopy.x + 8.0f + (float)(x * 16)) * globalScale + centeringX));
                    from.add((Number)Float.valueOf((fromCopy.y + 8.0f + (float)(y * 16)) * globalScale + centeringY));
                    from.add((Number)Float.valueOf((fromCopy.z + 8.0f + (float)(z * 16)) * globalScale + centeringZ));
                    blockElementObj.add("from", (JsonElement)from);
                    JsonArray to = new JsonArray();
                    to.add((Number)Float.valueOf((toCopy.x + 8.0f + (float)(x * 16)) * globalScale + centeringX));
                    to.add((Number)Float.valueOf((toCopy.y + 8.0f + (float)(y * 16)) * globalScale + centeringY));
                    to.add((Number)Float.valueOf((toCopy.z + 8.0f + (float)(z * 16)) * globalScale + centeringZ));
                    blockElementObj.add("to", (JsonElement)to);
                    if (blockElement.field_4232 != null) {
                        class_2350 rotatedDirection;
                        class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)blockElement.field_4232.comp_1119());
                        if (direction == (rotatedDirection = class_2350.method_23225((Matrix4f)state.method_3509().method_22936(), (class_2350)direction))) {
                            blockElementObj.add("rotation", (JsonElement)BlocksToJsonModel.serializeRotation(blockElement.field_4232, x, y, z, globalScale, centeringX, centeringY, centeringZ));
                        } else {
                            class_789 newRotation = new class_789(blockElement.field_4232.comp_1118(), rotatedDirection.method_10166(), rotatedDirection.method_10171() == class_2350.class_2352.field_11060 ? -blockElement.field_4232.comp_1120() : blockElement.field_4232.comp_1120(), blockElement.field_4232.comp_1121());
                            blockElementObj.add("rotation", (JsonElement)BlocksToJsonModel.serializeRotation(newRotation, x, y, z, globalScale, centeringX, centeringY, centeringZ));
                        }
                    }
                    if (!blockElement.field_4229) {
                        blockElementObj.addProperty("shade", Boolean.valueOf(false));
                    }
                    elements.add((JsonElement)blockElementObj);
                }
            }
        });
        jsonObject.add("elements", (JsonElement)elements);
        JsonObject textures = new JsonObject();
        for (Map.Entry entry : textureReferences.entrySet()) {
            class_2960 resourceLocation = (class_2960)entry.getKey();
            if (resourceLocation.method_12836().equals("minecraft")) {
                textures.addProperty((String)entry.getValue(), ((class_2960)entry.getKey()).method_12832());
                continue;
            }
            textures.addProperty((String)entry.getValue(), ((class_2960)entry.getKey()).toString());
        }
        jsonObject.add("textures", (JsonElement)textures);
        return jsonObject;
    }

    public static class_4590 getUVTransform(class_4590 transformation, class_2350 direction) {
        class_2350 direction2 = class_2350.method_23225((Matrix4f)transformation.method_22936(), (class_2350)direction);
        class_4590 transformation3 = ((class_4590)class_4609.field_21021.get(direction)).method_22933(transformation).method_22933((class_4590)class_4609.field_21022.get(direction2));
        return class_4609.method_23220((class_4590)transformation3);
    }

    public static class_787 recomputeUVNonLocked(class_787 blockFaceUV, class_2350 direction, class_4590 transformation) {
        Matrix4f matrix4f = BlocksToJsonModel.getUVTransform(transformation, direction).method_22936();
        float r = (float)Math.toRadians(blockFaceUV.field_4234);
        Matrix3f matrix3f = new Matrix3f((Matrix4fc)matrix4f);
        Vector3f vector3f = matrix3f.transform(new Vector3f(class_3532.method_15362((float)r), class_3532.method_15374((float)r), 0.0f));
        int s2 = Math.floorMod((int)Math.round(Math.toDegrees(Math.atan2(vector3f.y(), vector3f.x())) / 90.0) * 90, 360);
        float[] uvs = new float[]{blockFaceUV.field_4235[0], blockFaceUV.field_4235[1], blockFaceUV.field_4235[2], blockFaceUV.field_4235[3]};
        return new class_787(uvs, s2);
    }

    public static class_787 recomputeUVLocked(class_787 blockFaceUV, class_2350 direction, class_4590 transformation, String modelName) {
        float q;
        float p;
        float o;
        float n;
        Matrix4f matrix4f = class_4609.method_23221((class_4590)transformation, (class_2350)direction, () -> "Unable to resolve UVLock for model: " + modelName).method_22936();
        float f = blockFaceUV.method_3415(blockFaceUV.method_3414(0));
        float g2 = blockFaceUV.method_3416(blockFaceUV.method_3414(0));
        Vector4f vector4f = matrix4f.transform(new Vector4f(f / 16.0f, g2 / 16.0f, 0.0f, 1.0f));
        float h2 = 16.0f * vector4f.x();
        float i = 16.0f * vector4f.y();
        float j = blockFaceUV.method_3415(blockFaceUV.method_3414(2));
        float k = blockFaceUV.method_3416(blockFaceUV.method_3414(2));
        Vector4f vector4f2 = matrix4f.transform(new Vector4f(j / 16.0f, k / 16.0f, 0.0f, 1.0f));
        float l = 16.0f * vector4f2.x();
        float m4 = 16.0f * vector4f2.y();
        if (Math.signum(j - f) == Math.signum(l - h2)) {
            n = h2;
            o = l;
        } else {
            n = l;
            o = h2;
        }
        if (Math.signum(k - g2) == Math.signum(m4 - i)) {
            p = i;
            q = m4;
        } else {
            p = m4;
            q = i;
        }
        return new class_787(new float[]{n, p, o, q}, blockFaceUV.field_4234);
    }

    private static String getIdentifierForIndex(int index) {
        if (index == 0) {
            return "a";
        }
        StringBuilder identifier = new StringBuilder();
        for (int position = index; position > 0; position /= 26) {
            int modulo = position % 26;
            identifier.insert(0, (char)(97 + modulo));
        }
        return identifier.toString();
    }

    @NotNull
    private static JsonObject serializeRotation(class_789 rotation, int offsetX, int offsetY, int offsetZ, float globalScale, float centeringX, float centeringY, float centeringZ) {
        JsonObject rotationObj = new JsonObject();
        JsonArray origin = new JsonArray();
        origin.add((Number)Float.valueOf((rotation.comp_1118().x + (float)offsetX) / 0.0625f * globalScale + centeringX));
        origin.add((Number)Float.valueOf((rotation.comp_1118().y + (float)offsetY) / 0.0625f * globalScale + centeringY));
        origin.add((Number)Float.valueOf((rotation.comp_1118().z + (float)offsetZ) / 0.0625f * globalScale + centeringZ));
        rotationObj.add("origin", (JsonElement)origin);
        rotationObj.addProperty("axis", rotation.comp_1119().name().toLowerCase(Locale.ROOT));
        rotationObj.addProperty("angle", (Number)Float.valueOf(rotation.comp_1120()));
        if (rotation.comp_1121()) {
            rotationObj.addProperty("rescale", Boolean.valueOf(true));
        }
        return rotationObj;
    }

    private static List<ModelAndState> getBlockModels(class_1088 bakery, class_2680 blockState) {
        class_1100 model = (class_1100)bakery.field_5394.get(class_773.method_3340((class_2680)blockState));
        return BlocksToJsonModel.resolve(bakery, model, (class_3665)class_1086.field_5350, blockState);
    }

    private static List<ModelAndState> resolve(class_1088 bakery, class_1100 unbakedModel, class_3665 modelState, class_2680 blockState) {
        if (unbakedModel instanceof class_793) {
            class_793 blockModel = (class_793)unbakedModel;
            return List.of(new ModelAndState(blockModel, modelState));
        }
        if (unbakedModel instanceof class_807) {
            class_807 multiVariant = (class_807)unbakedModel;
            if (multiVariant.method_3497().isEmpty()) {
                return List.of();
            }
            int index = ThreadLocalRandom.current().nextInt(multiVariant.method_3497().size());
            class_813 variant = (class_813)multiVariant.method_3497().get(index);
            return BlocksToJsonModel.resolve(bakery, bakery.method_4726(variant.method_3510()), (class_3665)variant, blockState);
        }
        if (unbakedModel instanceof class_816) {
            class_816 multiPart = (class_816)unbakedModel;
            ArrayList<ModelAndState> models = new ArrayList<ModelAndState>();
            for (class_819 selector : multiPart.method_3519()) {
                Predicate predicate = selector.method_3530(blockState.method_26204().method_9595());
                if (!predicate.test(blockState)) continue;
                models.addAll(BlocksToJsonModel.resolve(bakery, (class_1100)selector.method_3529(), modelState, blockState));
            }
            return models;
        }
        if (unbakedModel instanceof DelegatingUnbakedModel) {
            DelegatingUnbakedModel delegatingUnbakedModel = (DelegatingUnbakedModel)unbakedModel;
            ArrayList<ModelAndState> models = new ArrayList<ModelAndState>();
            for (class_2960 dependency : delegatingUnbakedModel.method_4755()) {
                models.addAll(BlocksToJsonModel.resolve(bakery, bakery.method_4726(dependency), modelState, blockState));
            }
            return models;
        }
        return List.of();
    }

    private record ModelAndState(class_793 blockModel, class_3665 modelState) {
    }
}

